 ; Ŀ
 ;   Taz - relayer selected entities and subentities, colour bylayer.      
 ;   Copyright 1994 by Rocket Software                                     
 ;   Note: may hang on undo.                                               
 ;   Sadly, there are electric eels but no explosive ones.                 
 ; 

 ; Ŀ
 ;   Laye - ask for a layer name, allow keyboard input, entity selection,  
 ;   and offer the last layer chosen as the default.                       
 ; 
 (DEFUN LAYE (/ goon playy aa pa)
  (if (= (type layy) 'STR)
   (prompt (strcat "Select an entity or enter a name (<Return> = " layy "): "))
      (prompt "Select an entity or enter a name: "))
 ; Use grread to get points so can also accept keyboard input.
  (setq goon t)
  (setq playy "")
  (while (and goon (setq aa (grread () 2)))
         (cond ((= (car aa) 3)                             ; a point
                (setq goon ())                             ; leave loop
                (setq pa (cadr aa)))                       ; save point
               ((equal aa (list 2 13))                     ; <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 6 0))                      ; Digitizer <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 2 195))                    ; F9
                (setvar "snapmode" (1- (getvar "snapmode"))))
               ((equal aa (list 2 194))                    ; F8
                (setvar "orthomode" (1- (getvar "orthomode"))))
               ((equal (car aa) 2)                         ; a keypress
                (setq playy (strcat playy (setq aa (chr (cadr aa)))))
                (princ aa))))
  (if pa
      (progn
           (if (/= playy "") (prompt "\nPoint override."))
           (setq playy (nentselp pa))
           (if playy
              (if (= (type (caar (reverse playy))) 'ENAME)
                  (setq layy (cdr (assoc 8 (entget (caar (reverse playy))))))
                  (setq layy (cdr (assoc 8 (entget (car playy))))))
              (setq layy ())))
      (if (/= playy "") (setq layy playy)))
 layy)
 ; Ŀ
 ;   Laye end.                                                             
 ; 

 ; Ŀ
 ;   Teaze - the mechanical part - written as a subroutine for ease of     
 ;   recursion.                                                            
 ; 
 (DEFUN TEAZE (blnam / blok namm entt num gnu nxt hi ss2 enam)
  (setq blok (tblsearch "block" blnam))       ; head entity from table
  (setq namm (cdr (assoc -2 blok)))           ; first ename after head
  (while namm
        (setq entt (entget namm))             ; the whole thing
        (if (or (= (cdr (assoc 0 entt)) "INSERT")     ; if it's another block
                (= (cdr (assoc 0 entt)) "DIMENSION")) ; or a dimension
            (teaze (cdr (assoc 2 entt))))             ; then recurse
        (setq num 0)
        (setq gnu ())
        (while (setq nxt (nth num entt))
               (cond ((= (car nxt) 8)
                      (setq gnu (append gnu (list (cons 8 "0")))))
                     ((= (car nxt) 62)
                      (setq gnu (append gnu (list (cons 62 256)))))
                     (t  
                      (setq gnu (append gnu (list nxt)))))
               (setq num (1+ num)))
        (entmod gnu)                         ; change subent in block tables
        (setq namm (entnext namm)))          ; next subentity ename
 ; Ŀ
 ;   Update the individual insertions.                                     
 ; 
  (setq hi (getvar "highlight"))
  (setq ss2 (ssget "X" (list (cons 2 blnam))))
  (setvar "highlight" hi)
  (if ss2
      (progn
           (command "change" ss2 "" "p" "la" layy "")
           (while (setq esav (setq enam (ssname ss2 0)))
                  (if (assoc 66 (entget enam))
                      (progn
                           (while (/= (cdr (assoc 0 (setq entt (entget 
                                      (setq enam (entnext enam)))))) "SEQEND")
                                  (setq entt (subst (cons 8 layy)
                                                    (assoc 8 entt) entt))
                                  (if (assoc 62 entt)
                                      (setq entt (subst (cons 62 256)
                                                        (assoc 62 entt) entt)))
                                  (entmod entt))))
                  (entupd enam)
                  (ssdel esav ss2))))
 (princ))
 ; Ŀ
 ;   Teaze end.                                                            
 ; 

 ; Ŀ
 ;   Taz - the maniacal omnivore.                                          
 ; 
 (DEFUN C:TAZ (/ tbdata newl ss enam typ entt blnam blist)
  (setvar "cmdecho" 0)
  (setq layy (laye))                           ; call laye to get a layer name
  (if layy
      (setq tbdata (tblsearch "layer" layy)))  ; see if the layer exists
  (if (null tbdata)
      (progn
           (initget 0 "Yes No")
           (Setq newl (getkword (strcat "\nLayer " layy " not found."
                                        " Make it? <Y>: ")))
           (if (or (null newl) (= newl "Yes"))
               (command "layer" "new" layy "")))
      (prompt (strcat "\nDestination layer: " layy)))
  (if (tblsearch "layer" layy)
      (progn
           (setq ss (ssget))
           (if ss (command "change" ss "" "P" "La" layy ""))
           (while (and ss (setq enam (ssname ss 0)))
                  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                  (if (or (= typ "INSERT") (= typ "DIMENSION"))
                      (progn
                           (setq blnam (cdr (assoc 2 entt)))
                           (if (not (member blnam blist))
                               (progn
                                    (setq blist (append blist (list blnam)))
                                    (teaze blnam)
                                    (if (= typ "DIMENSION") (entupd enam))))))
                  (ssdel enam ss)))
      (if (= newl "No")
          (prompt "Have it your way.")
          (prompt "Layer unavailable.")))
 (princ))